﻿#region usings
using System;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows;
using System.Windows.Forms;

using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.Threading;
using System.IO;

using AForge.Video;
using AForge.Video.VFW;
using AForge.Video.DirectShow;
using AForge.Imaging.Filters;
using AForge;
using AForge.Imaging;
#endregion

namespace Image_analyzer
{
	public partial class MainForm : Form
	{
		//     TOOLBAR       ################################
		
		#region Main_bar
		void Tbtn_bild_ladenClick(object sender, EventArgs e)
		{
			if (openFileDialog1.ShowDialog() == DialogResult.OK) 
			{
				pic_backbox.Image = new Bitmap(openFileDialog1.FileName);
				Picbox1.Image = new Bitmap(openFileDialog1.FileName);
				timer_off.Enabled = true;
			}
		}
      	void Btn_func_KameraClick(object sender, EventArgs e)
		{
			if (btn_func_Kamera.ForeColor == Color.Red) {
				btn_func_Kamera.ForeColor = Color.Lime;
				btn_func_Kamera.Text = "Kamera ON";
				tool_1_camera.Visible = true;
				tool_1_camera.Top = 0;
				Kernel_suche_kameras();
			} else {
				btn_func_Kamera.ForeColor = Color.Red;
				btn_func_Kamera.Text = "Kamera OFF";
				Kernel_schließe_kamera();
				tool_1_camera.Visible = false;
			}
			HauptformResizeEnd(null,null);
		}
		void Btn_func_videoClick(object sender, EventArgs e)
		{
			if (btn_func_video.ForeColor == Color.Red) {
				btn_func_video.ForeColor = Color.Lime;
				btn_func_video.Text = "Video ON";
				VF.Show();
				VF.BringToFront();
			} else {
				VF.Hide();
				btn_func_video.ForeColor = Color.Red;
				btn_func_video.Text = "Video OFF";
			}
			HauptformResizeEnd(null,null);
		}
		void Btn_func_filterClick(object sender, EventArgs e)
		{
			if (btn_func_filter.ForeColor == Color.Red) {
				btn_func_filter.ForeColor = Color.Lime;
				btn_func_filter.Text = "Filter ON";
				tool_filter.Visible = true;
			} else {
				btn_func_filter.ForeColor = Color.Red;
				btn_func_filter.Text = "Filter OFF";
				Kernel_close_all_filters();
				tool_filter.Visible = false;
				panel_filter_setup.Visible = false;
			}
			HauptformResizeEnd(null,null);
		}
		void Btn_func_sonstigesClick(object sender, EventArgs e)
		{
			if (btn_func_sonstiges.ForeColor == Color.Red) {
				btn_func_sonstiges.ForeColor = Color.Lime;
				btn_func_sonstiges.Text = "Sonstiges ON";
				tool_0_sonstiges.Visible = true;
				tool_0_sonstiges.Top = 0;
			} else {
				btn_func_sonstiges.ForeColor = Color.Red;
				btn_func_sonstiges.Text = "Sonstiges OFF";
				tool_0_sonstiges.Visible = false;
			}
			HauptformResizeEnd(null,null);
		}
      	void ExitToolStripMenuItemClick(object sender, EventArgs e)
		{
      		Kernel_schließe_kamera();
			AVI_write.Close();
			AVI_read.Close();
			Application.Exit();
		}
      	void ModusStretchStandardToolStripMenuItemClick(object sender, EventArgs e)
		{
      		main_autosize = false;
			Picbox1.SizeMode = PictureBoxSizeMode.StretchImage;
		}
		void ModusCenterImageToolStripMenuItemClick(object sender, EventArgs e)
		{
			main_autosize = false;
			Picbox1.SizeMode = PictureBoxSizeMode.CenterImage;
		}
		void ImageZoomToolStripMenuItemClick(object sender, EventArgs e)
		{
			main_autosize = false;
			Picbox1.SizeMode = PictureBoxSizeMode.Zoom;
		}
		void Modus_autoimagezoomClick(object sender, EventArgs e)
		{
			main_autosize = true;
			Picbox1.SizeMode = PictureBoxSizeMode.Zoom;
		}
      	void Txt_imagenameTextChanged(object sender, EventArgs e)
		{
			pic_nr = 0;
		}
      	void SpeichernToolStripMenuItemClick(object sender, EventArgs e)
		{
			try 
			{	
				if (Picbox1.Image != null) {
					Picform seond = new Picform();
					seond.Show();
					seond.pictureBox1.Image = (Bitmap)Picbox1.Image.Clone();
					seond.text_pfad.Text = txt_imagename.Text + "_" + pic_nr;
					pic_nr++;
				}
			} catch (Exception err) 
			{
				timer_off.Enabled = false;
				info_err.Visible = true;
        		info_err.Text = "Fehler in (Save JPG):\r\n"+err.Message;
			}
		}
		void ToolStripMenuItem2Click(object sender, EventArgs e)
		{
			Clipboard.SetImage(Picbox1.Image);
		}
		void KamerabildEinfrierenToolStripMenuItemClick(object sender, EventArgs e)
		{
			if (kamerabildEinfrierenToolStripMenuItem.Text == "Kamerabild einfrieren") 
			{
				if (video1 == null) 
				{
					MessageBox.Show("Kamera ist inaktiv.");
					return;
				}
				Kernel_schließe_kamera();
				working = false;
				timer_off.Enabled = true;
				kamerabildEinfrierenToolStripMenuItem.Text = "Kamera starten";
			}
			else if (kamerabildEinfrierenToolStripMenuItem.Text == "Kamera starten") 
			{
				timer_off.Enabled = false;
				working = false;
				Kernel_öffne_kamera();
				kamerabildEinfrierenToolStripMenuItem.Text = "Kamerabild einfrieren";
			}
		}
		void ScreenshotToolStripMenuItemClick(object sender, EventArgs e)
		{
			//Form verstecken, laufende Kameras ausschalten und warten, damit das Fenster sich schließen kann
			this.Hide();
			Kernel_schließe_kamera();
			Thread.Sleep(500);
			//erstelle ein bitmap und befülle es mit dem bildschirminhalt des hauptbildschirms
			Bitmap grab = new Bitmap(Screen.PrimaryScreen.Bounds.Width, Screen.PrimaryScreen.Bounds.Height, PixelFormat.Format24bppRgb);
			Graphics gfxgrab = Graphics.FromImage(grab);
			gfxgrab.CopyFromScreen(Screen.PrimaryScreen.Bounds.X, Screen.PrimaryScreen.Bounds.Y, 0, 0, Screen.PrimaryScreen.Bounds.Size, CopyPixelOperation.SourceCopy);
			//screenshot ausgeben
			pic_backbox.Image = grab;
			Picbox1.Image = grab;
			//form anzeigen und Bildbearbeitungstimer starten
			this.Show();
			HauptformResizeEnd(null,null);
			timer_off.Enabled = true;
		}
		void FilterToolStripMenuItemClick(object sender, EventArgs e)
		{
			if (filterToolStripMenuItem.ForeColor == Color.Red) {
				filterToolStripMenuItem.ForeColor = Color.Lime;
				FF.Show();
				FF.BringToFront();
			} else {
				filterToolStripMenuItem.ForeColor = Color.Red;
				FF.Hide();
			}
		}
		void VideoToolStripMenuItemClick(object sender, EventArgs e)
		{
			if (VideoToolStripMenuItem.ForeColor == Color.Red) {
				VideoToolStripMenuItem.ForeColor = Color.Lime;
				this.Width += 220;
//				Application.DoEvents();
				toolStripContainer1.Width = this.Width - 220; //Sidebar sichtbar
				tab_sidebar.Visible = true;
				CB_video_codecs.Items.Clear();
				FilterInfoCollection codecList = new FilterInfoCollection(FilterCategory.VideoCompressorCategory);
				foreach (FilterInfo info in codecList)
				{
					string[] split_s = info.MonikerString.Split('\\');
					if (split_s.Length == 2) {
						if (split_s[1].Length < 5) {
							CB_video_codecs.Items.Add(split_s[1]);
							if (split_s[1] == "msvc") {
								CB_video_codecs.SelectedIndex = CB_video_codecs.Items.Count - 1;
							}
						}
					}
				}
			} else {
				this.Width -= 220;
				VideoToolStripMenuItem.ForeColor = Color.Red;
//				Application.DoEvents();
				tab_sidebar.Visible = false;
				toolStripContainer1.Width = this.Width - 8; //grundstellung
			}
			HauptformResizeEnd(null,null);
			Btn_video_CopySettingsFromIMGClick(null,null);
		}
		
		#endregion

		#region tool_camera
		void TBtn_cam_suchenClick(object sender, EventArgs e)
		{
			Kernel_suche_kameras();
		}
      	void TBtn_cam_startClick(object sender, EventArgs e)
		{
			Kernel_öffne_kamera();
		}
		void Tbtn_cam_stopClick(object sender, EventArgs e)
		{
			Kernel_schließe_kamera();
		}
		void Txt_cam_breiteTextChanged(object sender, EventArgs e)
		{
			cam_W = 0;
			int.TryParse(Txt_cam_breite.Text, out cam_W);
			if (cam_W > 0) {
				Txt_cam_breite.BackColor = Color.White;
			} else {
				Txt_cam_breite.BackColor = Color.Red;
			}
		}
		void Txt_cam_höheTextChanged(object sender, EventArgs e)
		{
			cam_H = 0;
			int.TryParse(Txt_cam_höhe.Text, out cam_H);
			if (cam_H > 0) {
				Txt_cam_höhe.BackColor = Color.White;
			} else {
				Txt_cam_höhe.BackColor = Color.Red;
			}
		}
		void Txt_cam_fpsTextChanged(object sender, EventArgs e)
		{
			cam_fps = 0;
			int.TryParse(Txt_cam_fps.Text, out cam_fps);
			if (cam_fps > 0) {
				Txt_cam_fps.BackColor = Color.White;
				Txt_cam_fps_ms.Text = ((int)Math.Round(1000/(float)cam_fps)).ToString();
			} else {
				Txt_cam_fps.BackColor = Color.Red;
			}
		}
		void Txt_cam_fps_msTextChanged(object sender, EventArgs e)
		{
			cam_fps_in_ms = 0;
			int.TryParse(Txt_cam_fps_ms.Text, out cam_fps_in_ms);
			if (cam_fps_in_ms > 0) {
				Txt_cam_fps_ms.BackColor = Color.White;
			} else {
				Txt_cam_fps_ms.BackColor = Color.Red;
			}
		}
		void Tbtn_cam_EigenschaftenClick(object sender, EventArgs e)
		{
			try {
				video1.DisplayPropertyPage(this.Handle);
//				string output = "";
//				for (int i = 0;i<8 ;i++ ) {
//					output += video1.VideoCapabilities[i].FrameSize.ToString()+" "+video1.VideoCapabilities[i].MaxFrameRate.ToString()+"\r\n";
//				}
//				MessageBox.Show(output);
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Konnte Kameraeinstellungen nicht öffnen");
			}
		}
		void Tcb_cam_auflösungenSelectedIndexChanged(object sender, EventArgs e)
		{
			try {
				Txt_cam_höhe.Text = video1.VideoCapabilities[tcb_cam_auflösungen.SelectedIndex].FrameSize.Height.ToString();
				Txt_cam_breite.Text = video1.VideoCapabilities[tcb_cam_auflösungen.SelectedIndex].FrameSize.Width.ToString();
				Txt_cam_fps.Text = video1.VideoCapabilities[tcb_cam_auflösungen.SelectedIndex].MaxFrameRate.ToString();
				video1.SignalToStop();
				Application.DoEvents(); Thread.Sleep(300);
				video1.DesiredFrameRate = cam_fps;
                timer_on.Interval = cam_fps_in_ms;
                video1.DesiredFrameSize = new Size(cam_W, cam_H);
                video1.Start();
                //Formabmaße nach 30 bildern aud die neue Auflösung anpassen
                Main_doResize = 30;
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Konnte Kameraeinstellungen nicht auslesen");
			}
		}
		void CB_cam_devicesSelectedIndexChanged(object sender, EventArgs e)
		{
			Kernel_schließe_kamera();
		}
		#endregion
		
		#region tool_filter
		void Num_maus_zoomboxValueChanged(object sender, EventArgs e)
		{
			maus_zoombox = (int)num_maus_zoombox.Value;
		}
		void Bar_maus_faktorScroll(object sender, EventArgs e)
		{
			maus_zoomfaktor = Bar_maus_faktor.Value;
		}
		void Tbtn_maus_setupClick(object sender, EventArgs e)
		{
			if (panel_filter_setup.Visible) 
			{
				panel_filter_setup.Visible = false;
			} else {
				panel_filter_setup.Top = 15; panel_filter_setup.Left = 12;
				panel_filter_setup.Visible = true;
			}
		}
      	void Tbtn_filter_backboxenClick(object sender, EventArgs e)
		{
			if (Tbtn_filter_backboxen.ForeColor != Color.Lime) {
				pic_backbox.Visible = true;
				pic_backfilter.Visible = true;
				Tbtn_filter_backboxen.ForeColor = Color.Lime;
			} else {
				pic_backbox.Visible = false;
				pic_backfilter.Visible = false;
				Tbtn_filter_backboxen.ForeColor = Color.Black;
			}
		}
      	void Tbtn_filter_cropClick(object sender, EventArgs e)
		{
			FF.check_crop.Checked = !FF.check_crop.Checked;
		}
      	void Tbtn_filter_averageClick(object sender, EventArgs e)
		{
      		FF.check_avr.Checked = !FF.check_avr.Checked;
		}
      	void Tbtn_filter_kantenClick(object sender, EventArgs e)
		{
      		FF.check_nurKanten.Checked = !FF.check_nurKanten.Checked;
		}
		void Tbtn_filter_convolutionClick(object sender, EventArgs e)
		{
			FF.check_kanten.Checked = !FF.check_kanten.Checked;
		}
		void Tbtn_filter_pseudocolorClick(object sender, EventArgs e)
		{
			FF.check_pseudo.Checked = !FF.check_pseudo.Checked;
		}
		void Tbtn_filter_objektfinderClick(object sender, EventArgs e)
		{
			FF.check_blobcounter.Checked = !FF.check_blobcounter.Checked;
		}
		void Tbtn_filter_hintergrundfilternClick(object sender, EventArgs e)
		{
			if (Tbtn_filter_hintergrundfiltern.ForeColor == Color.Red) {
				Tbtn_filter_hintergrundfiltern.ForeColor = Color.Black;
				Filt_im_Hintergrund = false;
			} else {
				Tbtn_filter_hintergrundfiltern.ForeColor = Color.Red;
				Filt_im_Hintergrund = true;
			}
		}
		#endregion
		
		#region tool_sonstiges
		
		
		void Tbtn_maus_activeClick(object sender, EventArgs e)
		{
			if (Tbtn_maus_active.ForeColor != Color.Lime) {
				Tbtn_maus_active.ForeColor = Color.Lime;
				maus_active = true;
			} else {
				Tbtn_maus_active.ForeColor = Color.Black;
				maus_active = false;
			}
		}
		void Tbtn_maus_pseudoClick(object sender, EventArgs e)
		{
			if (Tbtn_maus_pseudo.ForeColor != Color.Lime) {
				Tbtn_maus_pseudo.ForeColor = Color.Lime;
				maus_pseudo = true;
			} else {
				Tbtn_maus_pseudo.ForeColor = Color.Black;
				maus_pseudo = false;
			}
		}
		void Tbtn_sonst_timeron_setClick(object sender, EventArgs e)
		{
			int.TryParse(txt_sonst_timeroninter.Text, out cam_fps_in_ms);
			if (cam_fps_in_ms > 0) 
			{
				timer_on.Interval = (int)Math.Round(1000/(float)cam_fps_in_ms);
			}
			else
			{
				MessageBox.Show("Interval ("+txt_sonst_timeroninter.Text+") nicht gesetzt.");
			}
		}
		void Tbtn_sonst_timeroff_setClick(object sender, EventArgs e)
		{
			int.TryParse(txt_sonst_timeroffinter.Text, out avi_fps_in_ms);
			if (avi_fps_in_ms > 0) 
			{
				timer_off.Interval = (int)Math.Round(1000/(float)avi_fps_in_ms);
			}
			else
			{
				MessageBox.Show("Interval ("+txt_sonst_timeroffinter.Text+") nicht gesetzt.");
			}
		}
		void Tbtn_sonst_ReadTimerstateClick(object sender, EventArgs e)
		{
			string output = "Timer_on Enabled ("+timer_on.Enabled.ToString()+") Interval ("+timer_on.Interval.ToString()+")\r\n";
			output += "Timer_off Enabled ("+timer_off.Enabled.ToString()+") Interval ("+timer_off.Interval.ToString()+")";
			MessageBox.Show(output,"Status der Timer");
		}
		void Tbtn_sonst_bildspeichernClick(object sender, EventArgs e)
		{
			Directory.CreateDirectory("img");
			switch (tcb_Bildformat.SelectedIndex) {
				case 0://JPG
					//codecs auslesen und jpg codec finden
		        	ImageCodecInfo[] codecs = ImageCodecInfo.GetImageEncoders();
		        	ImageCodecInfo JC = null ;
		        	for(int i=0; i<codecs.Length; i++)
		        	{
		        		if(codecs[i].MimeType == "image/jpeg") {
		        			JC = codecs[i]; break;
		        		}
		        	}
		        	//Codec Parameter einstellen
		        	EncoderParameter GP = new EncoderParameter(System.Drawing.Imaging.Encoder.Quality, 95L);
		        	EncoderParameters EP = new EncoderParameters(1);
		          	EP.Param[0] = GP;
		          	//Bild Speichern
		          	Picbox1.Image.Save(@"img/"+txt_sonst_bildname.Text+".jpg",JC,EP);
					break;
				case 1://PNG
					Picbox1.Image.Save(@"img/"+txt_sonst_bildname.Text+".png",ImageFormat.Png);
					break;
				case 2://BMP
					Picbox1.Image.Save(@"img/"+txt_sonst_bildname.Text+".bmp",ImageFormat.Bmp);
					break;
			}
			//Bildnamen ändern
          	string[] splits = txt_sonst_bildname.Text.Split('_');
            if (splits.Length > 1) {
            	//letzte nummer nach _ um eins nach oben zählen
            	int nummer = 0;
            	int.TryParse(splits[splits.Length-1],out nummer);
            	txt_sonst_bildname.Text = txt_sonst_bildname.Text.Replace("_"+nummer.ToString(),"_"+(nummer+1).ToString());
            } else {
            	txt_sonst_bildname.Text = txt_sonst_bildname.Text + "_0";
            }
		}
		
		void Panel_maus_colorClick(object sender, EventArgs e)
		{
			if ( colorDialog.ShowDialog() == DialogResult.OK )
			{ 
			 	panel_maus_color.BackColor = colorDialog.Color;
			 	mousepanel_X1.BackColor = colorDialog.Color;
			 	mousepanel_X2.BackColor = colorDialog.Color;
			 	mousepanel_Y1.BackColor = colorDialog.Color;
			 	mousepanel_Y2.BackColor = colorDialog.Color;
			 	P_pic_zoom.BackColor = colorDialog.Color;
			 	Maus_col = colorDialog.Color;
			}
		}
		#endregion
		
		#region Video_Sidebar
		//Video
		void Btn_video_erstellenClick(object sender, EventArgs e)
		{
			Kernel_erstelle_AVI();
		}
		void But_video_grabframeClick(object sender, EventArgs e)
		{
			avi_addframe = true;
		}
		void CHK_video_recordCheckedChanged(object sender, EventArgs e)
		{
			if (CHK_video_record.Checked) {
				CHK_video_record.BackColor = Color.Red;
			} else {
				CHK_video_record.BackColor = Color.Gainsboro;
			}
			avi_Record = CHK_video_record.Checked;
		}
		void CHK_video_PlayCheckedChanged(object sender, EventArgs e)
		{
			if (CHK_video_Play.Checked) {
				CHK_video_Play.BackColor = Color.Lime;
			} else {
				CHK_video_Play.BackColor = Color.Gainsboro;
			}
			avi_Play = CHK_video_Play.Checked;
		}
		void Btn_video_CopySettingsFromCAMClick(object sender, EventArgs e)
		{
			num_avi_FPS.Value = (decimal)cam_fps;
			num_avi_H.Value = (decimal)cam_H;
			num_avi_W.Value = (decimal)cam_W;
		}
		void Btn_video_CopySettingsFromIMGClick(object sender, EventArgs e)
		{
			num_avi_H.Value = (decimal)Picbox1.Image.Height;
			num_avi_W.Value = (decimal)Picbox1.Image.Width;
		}
		void Num_avi_stepsValueChanged(object sender, EventArgs e)
		{
			avi_steprange = (int)num_avi_steps.Value;
		}
		void CHK_video_RECPlayCheckedChanged(object sender, EventArgs e)
		{
			
			if (CHK_video_RECPlay.Checked) {
				CHK_video_RECPlay.BackColor = Color.Lime;
			} else {
				CHK_video_RECPlay.BackColor = Color.Gainsboro;
			}
			CHK_video_Play.Checked = CHK_video_RECPlay.Checked;
			CHK_video_record.Checked = CHK_video_RECPlay.Checked;
		}
		void CHK_video_REPlayCheckedChanged(object sender, EventArgs e)
		{
			avi_REPlay = CHK_video_REPlay.Checked;
		}
		void But_video_openfileClick(object sender, EventArgs e)
		{
			Kernel_öffne_AVI();
			txt_avi_openfileinfo.Text = "Start: "+AVI_read.Start.ToString()+"\r\n"+
				"Stop: "+AVI_read.Length.ToString()+"\r\n"+"FPS: "+AVI_read.FrameRate.ToString()+"\r\n"+
				"Codec: "+AVI_read.Codec+"\r\n"+"Breite: "+AVI_read.Width.ToString()+"\r\n"+"Höhe: "+AVI_read.Height.ToString();
			
		}
		void Btn_btn_video_stepdownClick(object sender, EventArgs e)
		{
			avi_stepdn = true;
		}
		void Btn_video_stepupClick(object sender, EventArgs e)
		{
			avi_stepup = true;
		}
		
		void Bar_video_readerScroll(object sender, EventArgs e)
		{
			AVI_readFrame(true);
		}
		void CHK_video_SpeedCheckedChanged(object sender, EventArgs e)
		{
			if (CHK_video_Speed.Checked) {
				panel_avi_speed.BackColor = Color.Gainsboro;
			} else {
				panel_avi_speed.BackColor = Color.Gray;
			}
			avi_speed = CHK_video_Speed.Checked;
		}
		void Bar_avi_speedScroll(object sender, EventArgs e)
		{
			avi_speed_val = Bar_avi_speed.Value;
			switch (avi_speed_val) {
				case 6:
				case 5: label_avi_speed.Text = "schnell vor"; break;
				case 4: label_avi_speed.Text = "normal vor"; break;
				case 3: 
				case 2: 
				case 1: label_avi_speed.Text = "langsam vor"; break;
				case 0: label_avi_speed.Text = "Stop"; break;
				case -1:
				case -2:
				case -3: label_avi_speed.Text = "langsam zurück"; break;
				case -4: label_avi_speed.Text = "normal zurück"; break;
				case -5:
				case -6: label_avi_speed.Text = "schnell zurück"; break;
			}
		}

		//Video_3
		void Setup_avirecClick(object sender, EventArgs e)
		{
			
		}
		#endregion
		
		//     Fenster       ################################
	}
	
	public unsafe class UnsafeBitmap
	{
		Bitmap bitmap;

		// three elements used for MakeGreyUnsafe
		int width;
		BitmapData bitmapData = null;
		Byte* pBase = null;
		public UnsafeBitmap(Bitmap bitmap)
		{
			this.bitmap = new Bitmap(bitmap);
		}
		public UnsafeBitmap(int width, int height)
		{
			this.bitmap = new Bitmap(width, height, PixelFormat.Format24bppRgb);
		}
		public void Dispose()
		{
			bitmap.Dispose();
		}
		public Bitmap Bitmap
		{
			get
			{
				return(bitmap);
			}
		}
		private Point PixelSize
		{
			get
			{
				GraphicsUnit unit = GraphicsUnit.Pixel;
				RectangleF bounds = bitmap.GetBounds(ref unit);

				return new Point((int) bounds.Width, (int) bounds.Height);
			}
		}
		public void LockBitmap()
		{
			GraphicsUnit unit = GraphicsUnit.Pixel;
			RectangleF boundsF = bitmap.GetBounds(ref unit);
			Rectangle bounds = new Rectangle((int) boundsF.X,
			                                 (int) boundsF.Y,
			                                 (int) boundsF.Width,
			                                 (int) boundsF.Height);
			
			// Figure out the number of bytes in a row
			// This is rounded up to be a multiple of 4
			// bytes, since a scan line in an image must always be a multiple of 4 bytes
			// in length.
			width = (int) boundsF.Width * sizeof(PixelData);
			if (width % 4 != 0)
			{
				width = 4 * (width / 4 + 1);
			}
			bitmapData =
				bitmap.LockBits(bounds, ImageLockMode.ReadWrite, PixelFormat.Format24bppRgb);
			pBase = (Byte*) bitmapData.Scan0.ToPointer();
		}
		public PixelData GetPixel(int x, int y)
		{
			PixelData returnValue = *PixelAt(x, y);
			return returnValue;
		}
		public void SetPixel(int x, int y, PixelData colour)
		{
			PixelData* pixel = PixelAt(x, y);
			*pixel = colour;
		}
		public void UnlockBitmap()
		{
			bitmap.UnlockBits(bitmapData);
			bitmapData = null;
			pBase = null;
		}
		public PixelData* PixelAt(int x, int y)
		{
			return (PixelData*)(pBase + y * width + x * sizeof(PixelData));
		}
	}
	public struct PixelData
	{
		public byte blue;
		public byte green;
		public byte red;
	}
}
